function sys_state = Closed_sys_performance(t,xx,A1,B1,Fs1,C1,A2,B2,Fs2,C2,A3,B3,Fs3,C3,Kx1,G1,M1,L1,H1,Kx2,G2,M2,L2,H2,Kx3,G3,M3,L3,H3)
z11 = xx(1);
z12 = xx(2);
z13 = xx(3);
z14 = xx(4);
z15 = xx(5);
z21 = xx(6);
z22 = xx(7);
z23 = xx(8);
z24 = xx(9);
z25 = xx(10);
z31 = xx(11);
z32 = xx(12);
z33 = xx(13);
z34 = xx(14);
z35 = xx(15);

x11 = xx(16);
x12 = xx(17);
x13 = xx(18);
x14 = xx(19);
x21 = xx(20);
x22 = xx(21);
x23 = xx(22);
x24 = xx(23);
x31 = xx(24);
x32 = xx(25);
x33 = xx(26);
x34 = xx(27);

global ffs1 ffs2 ffs3 hat_ffs1 hat_ffs2 hat_ffs3 Int_ts Int_count Int_tmp 
global yy11 yy12 yy13 yy14 yy21 yy22 yy23 yy24 yy31 yy32 yy33 yy34 
global yyn11 yyn12 yyn13 yyn14 yyn21 yyn22 yyn23 yyn24 yyn31 yyn32 yyn33 yyn34


X1 = [x11;x12;x13;x14];
X2 = [x21;x22;x23;x24];
X3 = [x31;x32;x33;x34];
Z1 = [z11;z12;z13;z14;z15];
Z2 = [z21;z22;z23;z24;z25];
Z3 = [z31;z32;z33;z34;z35];

f1 = fs1(t);
f2 = fs2(t);
f3 = fs3(t);

y1 = C1*X1 + Fs1*f1;
y2 = C2*X2 + Fs2*f2;
y3 = C3*X3 + Fs3*f3;

% Estimated state & sensor fault
hat_X1 = Z1 + H1*y1;
hat_X2 = Z2 + H2*y2;
hat_X3 = Z3 + H3*y3;

% controllers
u1 = -[Kx1 0]* hat_X1;
u2 = -[Kx2 0] * hat_X2;
u3 = -[Kx3 0] * hat_X3;

% observers
dot_Z1 = M1*Z1 + G1*u1 + L1*y1;
dot_Z2 = M2*Z2 + G2*u2 + L2*y2;
dot_Z3 = M3*Z3 + G3*u3 + L3*y3;

% sys dynamic
sigma10 = 67.6/180*pi; sigma20 = 67.7/180*pi; sigma30 = 67.7/180*pi; 
alpha12 = -27.49; alpha13 = -27.49; alpha21 = -23.10; alpha23 = -23.10;  alpha31 = -23.10; alpha32 = -23.10;
gamma12 = cos(0.5*(x11-x21 + 2*(sigma10 - sigma20))); gamma13 = cos(0.5*(x11-x31 + 2*(sigma10 - sigma30))); 
gamma21 = cos(0.5*(x21-x11 + 2*(sigma20 - sigma10))); gamma23 = cos(0.5*(x21-x31 + 2*(sigma20 - sigma30)));
gamma31 = cos(0.5*(x31-x11 + 2*(sigma30 - sigma10))); gamma32 = cos(0.5*(x31-x21 + 2*(sigma30 - sigma20)));
w12 = 0.5*(x11-x21); w13 = 0.5*(x11-x31);
w21 = 0.5*(x21-x11); w23 = 0.5*(x21-x31);
w31 = 0.5*(x31-x11); w32 = 0.5*(x31-x21);

h1 = 0.02*(alpha12*gamma12*sin(w12) + alpha13*gamma13*sin(w13));
h2 = 0.2*(alpha21*gamma21*sin(w21) + alpha23*gamma23*sin(w23));
h3 = 0.2*(alpha31*gamma31*sin(w31) + alpha32*gamma32*sin(w32));

Ms1 = [0; 1; 0; 0];
Ms2 = [0; 1; 0; 0]; 
Ms3 = [0; 1; 0; 0]; 

dot_X1 = A1*X1 + B1*u1 + Ms1*h1;
dot_X2 = A2*X2 + B2*u2 + Ms2*h2;
dot_X3 = A3*X3 + B3*u3 + Ms3*h3;

% sensor fault compensation
yc1 = y1 - Fs1*hat_X1(5);
yc2 = y2 - Fs2*hat_X2(5);
yc3 = y3 - Fs3*hat_X3(5);

if mod(Int_tmp,2)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
ffs1(Int_count) = f1;
ffs2(Int_count) = f2;
ffs3(Int_count) = f3;
hat_ffs1(Int_count) = hat_X1(5);
hat_ffs2(Int_count) = hat_X2(5);
hat_ffs3(Int_count) = hat_X3(5);
yy11(Int_count) =yc1(1);
yy12(Int_count) =yc1(2);
yy13(Int_count) =yc1(3);
yy14(Int_count) =yc1(4);
yy21(Int_count) =yc2(1);
yy22(Int_count) =yc2(2);
yy23(Int_count) =yc2(3);
yy24(Int_count) =yc2(4);
yy31(Int_count) =yc3(1);
yy32(Int_count) =yc3(2);
yy33(Int_count) =yc3(3);
yy34(Int_count) =yc3(4);

yyn11(Int_count) =y1(1);
yyn12(Int_count) =y1(2);
yyn13(Int_count) =y1(3);
yyn14(Int_count) =y1(4);
yyn21(Int_count) =y2(1);
yyn22(Int_count) =y2(2);
yyn23(Int_count) =y2(3);
yyn24(Int_count) =y2(4);
yyn31(Int_count) =y3(1);
yyn32(Int_count) =y3(2);
yyn33(Int_count) =y3(3);
yyn34(Int_count) =y3(4);
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_Z1;dot_Z2;dot_Z3;dot_X1;dot_X2;dot_X3];